/*
 * Decompiled with CFR 0.152.
 */
package frc.util.xml;

import frc.util.xml.XMLLoaderHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLLoaderContext<T> {
    private final XMLReader reader;
    private final List<XMLLoaderHandler> handlers;
    private final XMLLoaderHandler skipHandler;
    private T root;
    private Locator locator;

    protected XMLLoaderContext(XMLReader xMLReader) {
        this.reader = xMLReader;
        this.handlers = new ArrayList<XMLLoaderHandler>();
        this.skipHandler = new XMLLoaderHandler(this){

            protected String getDebugLabel() {
                return "### Ignored";
            }
        };
    }

    public final void setLocator(Locator locator) {
        this.locator = locator;
    }

    public T getRootObject() {
        return this.root;
    }

    public final Locator getLocator() {
        return this.locator;
    }

    public final XMLLoaderHandler getRootHandler() {
        return this.handlers.get(0);
    }

    public final XMLLoaderHandler getCurrentHandler() {
        return this.handlers.get(this.handlers.size() - 1);
    }

    public final XMLLoaderHandler getDefaultHandler() {
        return this.skipHandler;
    }

    public final int getLevel() {
        return this.handlers.size();
    }

    public final void push(XMLLoaderHandler xMLLoaderHandler, Attributes attributes) {
        xMLLoaderHandler.pushed(attributes);
        this.handlers.add(xMLLoaderHandler);
        this.reader.setContentHandler(xMLLoaderHandler);
    }

    public final void pop() {
        int n = this.handlers.size();
        this.handlers.remove(n - 1).poped();
        this.reader.setContentHandler(this.handlers.get(n - 2));
    }

    protected final void setup(T t, XMLLoaderHandler xMLLoaderHandler) {
        this.root = t;
        this.push(xMLLoaderHandler, null);
    }

    protected final void dump(String string, boolean bl) {
        int n = this.getLevel();
        while (n-- > 0) {
            System.out.print("  ");
        }
        if (bl) {
            String string2 = this.getCurrentHandler().getDebugLabel();
            if (string2 == null) {
                string2 = this.getCurrentHandler().getClass().getName();
                if ((string2 = string2.substring(string2.lastIndexOf(46) + 1)).equals("XMLLoaderHandler")) {
                    string2 = "???";
                }
            }
            System.out.println("<" + string + ">          \t" + string2);
        } else {
            System.out.println("</" + string + ">");
        }
    }
}

